/*
 * Copyright (C) 2022 Igalia S.L.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#if !defined(__WPE_H_INSIDE__) && !defined(WPE_COMPILATION)
#error "Only <wpe/wpe.h> can be included directly."
#endif

#ifndef wpe_process_h
#define wpe_process_h

/**
 * SECTION:process
 * @short_description: Process management
 * @title: Process
 */

#if defined(WPE_ENABLE_PROCESS) && WPE_ENABLE_PROCESS

#if defined(WPE_COMPILATION)
#include "export.h"
#endif

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

enum wpe_process_type {
    WPE_PROCESS_TYPE_WEB,
    WPE_PROCESS_TYPE_NETWORK,
    WPE_PROCESS_TYPE_GPU,
    WPE_PROCESS_TYPE_WEB_AUTHN,
};

struct wpe_process_provider;

struct wpe_process_provider_interface {
    void* (*create)(struct wpe_process_provider*);
    void (*destroy)(void*);
    int32_t (*launch)(void*, enum wpe_process_type, void*);
    void (*terminate)(void*, int32_t);
};

WPE_EXPORT
struct wpe_process_provider* wpe_process_provider_create(void);

WPE_EXPORT
void wpe_process_provider_destroy(struct wpe_process_provider*);

WPE_EXPORT
int32_t wpe_process_launch(struct wpe_process_provider*, enum wpe_process_type, void*);

WPE_EXPORT
void wpe_process_terminate(struct wpe_process_provider*, int32_t);

WPE_EXPORT
void wpe_process_provider_register_interface(struct wpe_process_provider_interface*);

#ifdef __cplusplus
}
#endif

#endif /* defined(WPE_ENABLE_PROCESS) && WPE_ENABLE_PROCESS */

#endif /* wpe_process_h */
